﻿//
// SplitPage.xaml.cpp
// SplitPage 类的实现
//

#include "pch.h"
#include "SplitPage.xaml.h"

using namespace $safeprojectname$;

using namespace Platform;
using namespace Platform::Collections;
using namespace concurrency;
using namespace Windows::Foundation;
using namespace Windows::Foundation::Collections;
using namespace Windows::Graphics::Display;
using namespace Windows::UI::ViewManagement;
using namespace Windows::UI::Xaml;
using namespace Windows::UI::Xaml::Controls;
using namespace Windows::UI::Xaml::Controls::Primitives;
using namespace Windows::UI::Xaml::Data;
using namespace Windows::UI::Xaml::Input;
using namespace Windows::UI::Xaml::Interop;
using namespace Windows::UI::Xaml::Media;
using namespace Windows::UI::Xaml::Navigation;

// “拆分页”项模板在 http://go.microsoft.com/fwlink/?LinkId=234234 上提供

SplitPage::SplitPage()
{
	InitializeComponent();
	SetValue(_defaultViewModelProperty, ref new Map<String^,Object^>(std::less<String^>()));
	auto navigationHelper = ref new Common::NavigationHelper(this,
		ref new Common::RelayCommand(
			[this](Object^) -> bool
			{
				return CanGoBack();
			},
			[this](Object^) -> void
			{
				GoBack();
			}
		)
	);
	SetValue(_navigationHelperProperty, navigationHelper);
	navigationHelper->LoadState += ref new Common::LoadStateEventHandler(this, &SplitPage::LoadState);
	navigationHelper->SaveState += ref new Common::SaveStateEventHandler(this, &SplitPage::SaveState);

	itemListView->SelectionChanged += ref new SelectionChangedEventHandler(this, &SplitPage::ItemListView_SelectionChanged);
	Window::Current->SizeChanged += ref new WindowSizeChangedEventHandler (this, &SplitPage::Window_SizeChanged);
	InvalidateVisualState();
}

DependencyProperty^ SplitPage::_defaultViewModelProperty =
	DependencyProperty::Register("DefaultViewModel",
		TypeName(IObservableMap<String^,Object^>::typeid), TypeName(SplitPage::typeid), nullptr);


/// <summary>
/// 用作普通视图模型。
/// </summary>
IObservableMap<String^, Object^>^ SplitPage::DefaultViewModel::get()
{
	return safe_cast<IObservableMap<String^, Object^>^>(GetValue(_defaultViewModelProperty));
}

DependencyProperty^ SplitPage::_navigationHelperProperty =
	DependencyProperty::Register("NavigationHelper",
		TypeName(Common::NavigationHelper::typeid), TypeName(SplitPage::typeid), nullptr);

/// <summary>
/// 获取 <see cref="NavigationHelper"/> 的实现，该实现旨在
/// 用作普通视图模型。
/// </summary>
Common::NavigationHelper^ SplitPage::NavigationHelper::get()
{
	//	return _navigationHelper;
	return safe_cast<Common::NavigationHelper^>(GetValue(_navigationHelperProperty));
}

bool SplitPage::CanGoBack()
{
	if (UsingLogicalPageNavigation() && itemListView->SelectedItem != nullptr)
	{
		return true;
	}
	else
	{
		return NavigationHelper->CanGoBack();
	}
}
void SplitPage::GoBack()
{
	if (UsingLogicalPageNavigation() && itemListView->SelectedItem != nullptr)
	{
		// 如果逻辑页导航起作用且存在选定项，则当前将显示
		// 选定项的详细信息。    清除选择后将返回到
		// 项列表。    从用户的角度来看，这是一个逻辑后向
		// 导航。
		itemListView->SelectedItem = nullptr;
	}
	else
	{
		NavigationHelper->GoBack();
	}
}

/// <summary>
/// 在 Window 改变大小时调用
/// </summary>
/// <param name="sender">当前的 Window</param>
/// <param name="e">描述 Window 新大小的事件数据</param>
void SplitPage::Window_SizeChanged(Platform::Object^ sender, Windows::UI::Core::WindowSizeChangedEventArgs^ e)
{
	InvalidateVisualState();
}

/// <summary>
/// 在选定列表中的项时进行调用。
/// </summary>
/// <param name="sender">显示所选项的 GridView。</param>
/// <param name="e">描述如何更改选择内容的事件数据。</param>
void SplitPage::ItemListView_SelectionChanged(Platform::Object^ sender, Windows::UI::Xaml::Controls::SelectionChangedEventArgs^ e)
{
	if (UsingLogicalPageNavigation())
	{
		InvalidateVisualState();
	}
}

/// <summary>
/// 在确定该页是应用作一个逻辑页还是两个逻辑页时进行调用。
/// </summary>
/// <returns>如果窗口应显示充当一个逻辑页，则为 True，
/// 。</returns>
bool SplitPage::UsingLogicalPageNavigation()
{
	return Windows::UI::Xaml::Window::Current->Bounds.Width < 768;
}

void SplitPage::InvalidateVisualState()
{
	auto visualState = DetermineVisualState();
	Windows::UI::Xaml::VisualStateManager::GoToState(this, visualState, false);
	NavigationHelper->GoBackCommand->RaiseCanExecuteChanged();
}

/// <summary>
/// 在确定对应于应用程序视图状态的视觉状态的名称时进行
/// 调用。
/// </summary>
/// <returns>所需的可视状态的名称。  此名称与视图状态的名称相同，
/// 但在纵向和对齐视图中存在选定项时例外，在纵向和对齐视图中，
/// 此附加逻辑页通过添加 _Detail 后缀表示。</returns>
Platform::String^ SplitPage::DetermineVisualState()
{
	if (!UsingLogicalPageNavigation())
		return "PrimaryView";

	// 在视图状态更改时更新后退按钮的启用状态
	auto logicalPageBack = UsingLogicalPageNavigation() && itemListView->SelectedItem != nullptr;

	return logicalPageBack ? "SinglePane_Detail" : "SinglePane";
}

/// <summary>
/// 使用在导航过程中传递的内容填充页。  在从以前的会话
/// 重新创建页时，也会提供任何已保存状态。
/// </summary>
/// <param name="sender">
/// 事件的来源; 通常为 <see cref="NavigationHelper"/>
/// </param>
/// <param name="e">事件数据，其中既提供在最初请求此页时传递给
/// <see cref="Frame::Navigate(Type, Object)"/> 的导航参数，又提供
/// 此页在以前会话期间保留的状态的
/// 字典。 首次访问页面时，该状态将为 null。</param>
void SplitPage::LoadState(Object^ sender, Common::LoadStateEventArgs^ e)
{
	(void) sender;	// 未使用的参数

	// TODO:  创建适用于问题域的合适数据模型以替换示例数据
	Data::SampleDataSource::GetGroup(safe_cast<String^>(e->NavigationParameter))
	.then([this, e](Data::SampleDataGroup^ group)
	{
		DefaultViewModel->Insert("Group", group);
		DefaultViewModel->Insert("Items", group->Items);
		if (e->PageState == nullptr)
		{
			this->itemListView->SelectedItem = nullptr;
			if (!UsingLogicalPageNavigation() && itemsViewSource->View != nullptr)
			{
				itemsViewSource->View->MoveCurrentToFirst();
			}
		}
		else
		{
			if (e->PageState->HasKey("SelectedItem") && itemsViewSource->View != nullptr)
			{
				Data::SampleDataSource::GetItem(safe_cast<String^>(e->PageState->Lookup("SelectedItem")))
					.then([this](Data::SampleDataItem^ selectedItem)
				{
					itemsViewSource->View->MoveCurrentTo(selectedItem);
				}, task_continuation_context::use_current());
			}
		}
	}, task_continuation_context::use_current());
}

/// <summary>
/// 保留与此页关联的状态，以防挂起应用程序或
/// 从导航缓存中放弃此页。  值必须符合
/// <see cref="SuspensionManager::SessionState"/> 的序列化要求。
/// </summary>
///<param name="sender">事件的来源；通常为 <see cref="NavigationHelper"/></param>
///<param name="e">提供要使用可序列化状态填充的空字典
///的事件数据。</param>
void SplitPage::SaveState(Object^ sender, Common::SaveStateEventArgs^ e)
{
	auto selectedItem = safe_cast<Data::SampleDataItem^>(itemListView->SelectedItem);
	if (selectedItem != nullptr)
	{
		e->PageState->Insert("SelectedItem", selectedItem->UniqueId);
	}
}

#pragma region Navigation support

/// 此部分中提供的方法只是用于使
/// NavigationHelper 可响应页面的导航方法。
/// 
/// 应将页面特有的逻辑放入用于
/// <see cref="NavigationHelper::LoadState"/>
/// 和 <see cref="NavigationHelper::SaveState"/> 的事件处理程序中。
/// 除了在会话期间保留的页面状态之外
/// LoadState 方法中还提供导航参数。

void SplitPage::OnNavigatedTo(NavigationEventArgs^ e)
{
	NavigationHelper->OnNavigatedTo(e);
}

void SplitPage::OnNavigatedFrom(NavigationEventArgs^ e)
{
	NavigationHelper->OnNavigatedFrom(e);
}

#pragma endregion